// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package generic

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestTreeUnify(t *testing.T) {
	ctx := context.Background()

	for _, testCase := range []struct {
		name            string
		originRoot      bool
		destinationRoot bool
	}{
		{
			name:            "Origin",
			originRoot:      true,
			destinationRoot: false,
		},
		{
			name:            "Destination",
			originRoot:      false,
			destinationRoot: true,
		},
		{
			name:            "None",
			originRoot:      false,
			destinationRoot: false,
		},
	} {
		t.Run(testCase.name, func(t *testing.T) {
			origin := newTestTree()
			if testCase.originRoot {
				origin.SetRoot(origin.Factory(ctx, kindTestNodeLevelOne))
			}
			destination := newTestTree()
			if testCase.destinationRoot {
				destination.SetRoot(destination.Factory(ctx, kindTestNodeLevelTwo))
			}
			TreeUnify(ctx, origin, destination, NewUnifyOptions(destination))
			if testCase.originRoot {
				destinationRoot := destination.GetRoot()
				assert.NotNil(t, destinationRoot)
				assert.EqualValues(t, kindTestNodeLevelOne, destinationRoot.GetKind())
			} else {
				assert.EqualValues(t, nil, destination.GetRoot())
			}
		})
	}
}
