# 2021-04-21 Triage Log

Another quiet week with very small changes to compiler performance.

Triage done by **@rylev**.
Revision range: [5258a74c887f8ae14717e1f98b652b470877ce4e..6df26f897cffb2d86880544bb451c6b5f8509b2d](https://perf.rust-lang.org/?start=5258a74c887f8ae14717e1f98b652b470877ce4e&end=6df26f897cffb2d86880544bb451c6b5f8509b2d&absolute=false&stat=instructions%3Au)

1 Regressions, 0 Improvements, 1 Mixed
0 of them in rollups

#### Regressions

Fix lookahead with None-delimited group [#84130](https://github.com/rust-lang/rust/issues/84130)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=7537b20626100e7e7fc8c4ad3079d38c05338121&end=16bf626a31cb5b121d0bca2baa969b4f67eb0dab&stat=instructions:u) (up to 1.4% on `incr-unchanged` builds of `deep-vector-check`)
- While this change fixes a bug, it does introduce moderate regressions in runtime performance on some benchmarks and a fairly large regression on the compilation of the rustc_parse crate itself. 
- We will [follow up](https://github.com/rust-lang/rust/pull/84130#issuecomment-823898920) on this particularly in the matter of `rustc_parse`'s compilation times regressing. 

#### Improvements

#### Mixed

Add some #[inline(always)] to arithmetic methods of integers [#84061](https://github.com/rust-lang/rust/issues/84061)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=392ba2ba1a7d6c542d2459fb8133bebf62a4a423&end=83ca4b7e600241850e61be48dee859f1604de50d&stat=instructions:u) (up to 1.7% on `full` builds of `regex-debug`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=392ba2ba1a7d6c542d2459fb8133bebf62a4a423&end=83ca4b7e600241850e61be48dee859f1604de50d&stat=instructions:u) (up to -1.3% on `incr-unchanged` builds of `cargo-check`)
- This change inlines a bunch of code that might not have been previously. It's not really a surprise that codegen now is taking longer to churn through all those inline calls.
- While this tradeoff on compile times for runtime performance is likely worth it, we are [checking in with the PR author and reviewer](https://github.com/rust-lang/rust/pull/84061#issuecomment-823908561) to make sure this is discussed.

#### Nags requiring follow up

- This week's follow ups:
    - https://github.com/rust-lang/rust/pull/84130#issuecomment-823898920


