; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

declare double @llvm.sqrt.f64(double)

define double @sqrt_div_fast(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div_fast(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = fdiv fast double [[Z:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = call fast double @llvm.sqrt.f64(double [[TMP0]])
; CHECK-NEXT:    [[DIV1:%.*]] = fmul fast double [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv fast double %y, %z
  %sqrt = call fast double @llvm.sqrt.f64(double %div)
  %div1 = fdiv fast double %x, %sqrt
  ret double %div1
}

define double @sqrt_div(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv double [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[SQRT:%.*]] = call double @llvm.sqrt.f64(double [[DIV]])
; CHECK-NEXT:    [[DIV1:%.*]] = fdiv double [[X:%.*]], [[SQRT]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv double %y, %z
  %sqrt = call double @llvm.sqrt.f64(double %div)
  %div1 = fdiv double %x, %sqrt
  ret double %div1
}

define double @sqrt_div_reassoc_arcp(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div_reassoc_arcp(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = fdiv reassoc arcp double [[Z:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = call reassoc arcp double @llvm.sqrt.f64(double [[TMP0]])
; CHECK-NEXT:    [[DIV1:%.*]] = fmul reassoc arcp double [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv arcp reassoc double %y, %z
  %sqrt = call arcp reassoc double @llvm.sqrt.f64(double %div)
  %div1 = fdiv arcp reassoc double %x, %sqrt
  ret double %div1
}

define double @sqrt_div_reassoc_missing(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div_reassoc_missing(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv arcp double [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[SQRT:%.*]] = call reassoc arcp double @llvm.sqrt.f64(double [[DIV]])
; CHECK-NEXT:    [[DIV1:%.*]] = fdiv reassoc arcp double [[X:%.*]], [[SQRT]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv arcp double %y, %z
  %sqrt = call arcp reassoc double @llvm.sqrt.f64(double %div)
  %div1 = fdiv arcp reassoc double %x, %sqrt
  ret double %div1
}

define double @sqrt_div_reassoc_missing2(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div_reassoc_missing2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv reassoc arcp double [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[SQRT:%.*]] = call arcp double @llvm.sqrt.f64(double [[DIV]])
; CHECK-NEXT:    [[DIV1:%.*]] = fdiv reassoc arcp double [[X:%.*]], [[SQRT]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv arcp reassoc double %y, %z
  %sqrt = call arcp double @llvm.sqrt.f64(double %div)
  %div1 = fdiv arcp reassoc double %x, %sqrt
  ret double %div1
}

define double @sqrt_div_reassoc_missing3(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div_reassoc_missing3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv reassoc arcp double [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[SQRT:%.*]] = call reassoc arcp double @llvm.sqrt.f64(double [[DIV]])
; CHECK-NEXT:    [[DIV1:%.*]] = fdiv arcp double [[X:%.*]], [[SQRT]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv arcp reassoc double %y, %z
  %sqrt = call arcp reassoc double @llvm.sqrt.f64(double %div)
  %div1 = fdiv arcp double %x, %sqrt
  ret double %div1
}

define double @sqrt_div_arcp_missing(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div_arcp_missing(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = fdiv reassoc double [[Z:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = call reassoc arcp double @llvm.sqrt.f64(double [[TMP0]])
; CHECK-NEXT:    [[DIV1:%.*]] = fmul reassoc arcp double [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv reassoc double %y, %z
  %sqrt = call arcp reassoc double @llvm.sqrt.f64(double %div)
  %div1 = fdiv arcp reassoc double %x, %sqrt
  ret double %div1
}

define double @sqrt_div_arcp_missing2(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div_arcp_missing2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv reassoc arcp double [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[SQRT:%.*]] = call reassoc double @llvm.sqrt.f64(double [[DIV]])
; CHECK-NEXT:    [[DIV1:%.*]] = fdiv reassoc arcp double [[X:%.*]], [[SQRT]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv arcp reassoc double %y, %z
  %sqrt = call reassoc double @llvm.sqrt.f64(double %div)
  %div1 = fdiv arcp reassoc double %x, %sqrt
  ret double %div1
}

define double @sqrt_div_arcp_missing3(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div_arcp_missing3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv reassoc arcp double [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[SQRT:%.*]] = call reassoc arcp double @llvm.sqrt.f64(double [[DIV]])
; CHECK-NEXT:    [[DIV1:%.*]] = fdiv reassoc double [[X:%.*]], [[SQRT]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv arcp reassoc double %y, %z
  %sqrt = call arcp reassoc double @llvm.sqrt.f64(double %div)
  %div1 = fdiv reassoc double %x, %sqrt
  ret double %div1
}

declare void @use(double)
define double @sqrt_div_fast_multiple_uses_1(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div_fast_multiple_uses_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv fast double [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    call void @use(double [[DIV]])
; CHECK-NEXT:    [[SQRT:%.*]] = call fast double @llvm.sqrt.f64(double [[DIV]])
; CHECK-NEXT:    [[DIV1:%.*]] = fdiv fast double [[X:%.*]], [[SQRT]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv fast double %y, %z
  call void @use(double %div)
  %sqrt = call fast double @llvm.sqrt.f64(double %div)
  %div1 = fdiv fast double %x, %sqrt
  ret double %div1
}

define double @sqrt_div_fast_multiple_uses_2(double %x, double %y, double %z) {
; CHECK-LABEL: @sqrt_div_fast_multiple_uses_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv fast double [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[SQRT:%.*]] = call fast double @llvm.sqrt.f64(double [[DIV]])
; CHECK-NEXT:    call void @use(double [[SQRT]])
; CHECK-NEXT:    [[DIV1:%.*]] = fdiv fast double [[X:%.*]], [[SQRT]]
; CHECK-NEXT:    ret double [[DIV1]]
;
entry:
  %div = fdiv fast double %y, %z
  %sqrt = call fast double @llvm.sqrt.f64(double %div)
  call void @use(double %sqrt)
  %div1 = fdiv fast double %x, %sqrt
  ret double %div1
}

define float @sqrt_non_div_operator(float %a) {
; CHECK-LABEL: @sqrt_non_div_operator(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = fpext float [[A:%.*]] to double
; CHECK-NEXT:    [[SQRT:%.*]] = call fast double @llvm.sqrt.f64(double [[CONV]])
; CHECK-NEXT:    [[DIV:%.*]] = fdiv fast double [[CONV]], [[SQRT]]
; CHECK-NEXT:    [[CONV2:%.*]] = fptrunc double [[DIV]] to float
; CHECK-NEXT:    ret float [[CONV2]]
;
entry:
  %conv = fpext float %a to double
  %sqrt = call fast double @llvm.sqrt.f64(double %conv)
  %div = fdiv fast double %conv, %sqrt
  %conv2 = fptrunc double %div to float
  ret float %conv2
}
