package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfirmPhysicalConnection invokes the vpc.ConfirmPhysicalConnection API synchronously
func (client *Client) ConfirmPhysicalConnection(request *ConfirmPhysicalConnectionRequest) (response *ConfirmPhysicalConnectionResponse, err error) {
	response = CreateConfirmPhysicalConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// ConfirmPhysicalConnectionWithChan invokes the vpc.ConfirmPhysicalConnection API asynchronously
func (client *Client) ConfirmPhysicalConnectionWithChan(request *ConfirmPhysicalConnectionRequest) (<-chan *ConfirmPhysicalConnectionResponse, <-chan error) {
	responseChan := make(chan *ConfirmPhysicalConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfirmPhysicalConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfirmPhysicalConnectionWithCallback invokes the vpc.ConfirmPhysicalConnection API asynchronously
func (client *Client) ConfirmPhysicalConnectionWithCallback(request *ConfirmPhysicalConnectionRequest, callback func(response *ConfirmPhysicalConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfirmPhysicalConnectionResponse
		var err error
		defer close(result)
		response, err = client.ConfirmPhysicalConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfirmPhysicalConnectionRequest is the request struct for api ConfirmPhysicalConnection
type ConfirmPhysicalConnectionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PhysicalConnectionId string           `position:"Query" name:"PhysicalConnectionId"`
}

// ConfirmPhysicalConnectionResponse is the response struct for api ConfirmPhysicalConnection
type ConfirmPhysicalConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfirmPhysicalConnectionRequest creates a request to invoke ConfirmPhysicalConnection API
func CreateConfirmPhysicalConnectionRequest() (request *ConfirmPhysicalConnectionRequest) {
	request = &ConfirmPhysicalConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ConfirmPhysicalConnection", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateConfirmPhysicalConnectionResponse creates a response to parse from ConfirmPhysicalConnection response
func CreateConfirmPhysicalConnectionResponse() (response *ConfirmPhysicalConnectionResponse) {
	response = &ConfirmPhysicalConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
